#include <iostream>
#include <string>

#include "searcher.h"
#include "movegen.h"
#include "make.h"
#include "log.h"
#include "attack.h"
#include "utils.h"
#include "hashtab.h"
#include "fen.h"


using namespace std;

cSearcher::cSearcher()
{
    mat.init_psqt();
    scorer.init_opt();
    scorer.init_mobility();
    book.setbookuse(false);
    init_opt();
}

void cSearcher::init_opt()
{
    opt->usehash = true;
    opt->donull = true;
    opt->pvs = true;
    opt->nullredfact = 3;
    opt->inifilename = "jabba.ini";//default, can be changed as commandline argument
    opt->aspiration = true;
    opt->aspwindow = 50;
}

void cSearcher::printstats()
{
    double p;
#ifdef DEBUG
    //if(logger.islog())logger.file<<"cSearcher::printstats()\n";
    cout<<"\nnulltry "<<stats->nulltry;
    cout<<" nullcuts "<<stats->nullcuts;
    p = percent(stats->nulltry, stats->nulltry+stats->nullcuts);
    cout<<" "<<p<<"%";
    cout<<"\nhashcuts "<<stats->hashcuts;
    cout<<"\nfh "<<stats->fh;
    cout<<" fhf "<<stats->fhf<<" ordering ";
    p = percent(stats->fhf, stats->fhf+stats->fh);
    cout<<" "<<p<<"%";
    cout<<"\nnodes "<<data->nodes;
    cout<<" qnodes "<<data->qnodes<<" ";
    p = percent(data->qnodes, data->nodes+data->qnodes);
    cout<<" "<<p<<"%";
    cout<<"\ncheckext = "<<stats->checkext;
    cout<<" pawnseventh = "<<stats->pawnseventh;
    cout<<" intopawnend = "<<stats->intopawnend;
    cout<<"\npvssearch = "<<stats->pvssearch;
    cout<<" pvsresearch = "<<stats->pvsresearch;
    p = percent(stats->pvsresearch, stats->pvssearch);
    cout<<" "<<p<<"%"<<endl;
#endif
    if(logger.islog())
    {
    logger.file<<"\nnulltry "<<stats->nulltry;
    logger.file<<" nullcuts "<<stats->nullcuts;
    p = percent(stats->nulltry, stats->nulltry+stats->nullcuts);
    logger.file<<" "<<p<<"%";
    logger.file<<"\nhashcuts "<<stats->hashcuts;
    logger.file<<"\nfh "<<stats->fh;
    logger.file<<" fhf "<<stats->fhf<<" ordering ";
    p = percent(stats->fhf, stats->fhf+stats->fh);
    logger.file<<" "<<p<<"%";
    logger.file<<"\nnodes "<<data->nodes;
    logger.file<<" qnodes "<<data->qnodes<<" ";
    p = percent(data->qnodes, data->nodes+data->qnodes);
    logger.file<<" "<<p<<"%";
    logger.file<<"\ncheckext = "<<stats->checkext;
    logger.file<<" pawnseventh = "<<stats->pawnseventh;
    logger.file<<" intopawnend = "<<stats->intopawnend;
    logger.file<<"\npvssearch = "<<stats->pvssearch;
    logger.file<<" pvsresearch = "<<stats->pvsresearch;
    p = percent(stats->pvsresearch, stats->pvssearch);
    logger.file<<" "<<p<<"%"<<endl;
    logger.file.flush();
    }
}


void cSearcher::resetstats()
{
   // if(logger.islog())logger.file<<"cSearcher::resetstats()\n";
    stats->nulltry=0;
    stats->nullcuts=0;
    stats->fh=0;
    stats->fhf=0;
    stats->hashcuts=0;
    stats->checkext=0;
    stats->pawnseventh=0;
    stats->intopawnend=0;
    stats->pvssearch=0;
    stats->pvsresearch=0;
}

void cSearcher::resetdata()
{
     game.setply(0);
     data->qnodes=0;
     data->nodes=0;
     data->bestmove = NULLMOVE;
     data->pondermove = NULLMOVE;
     data->lastscore = -matescore;
     status->stopped = RUNNING;
     status->interrupted = false;
     for(uint i = 0; i < maxply; ++i)
	 {
	   data->pvlen[i] = 0;
	   data->incheck[i] = false;
		 for(uint j = 0; j < maxply; ++j)
			 data->pv[i][j] = NULLMOVE;
	 }
     mlist.resethistab();
     mlist.resetkillers();
     mlist.resetstats();
     resetstats();
     param->iterdepth = timer.getdepth();

     ASS(param->iterdepth>0&&param->iterdepth<=maxply);

    // if(logger.islog())logger.file<<"cSearcher::resetdata()\n";
}

void cSearcher::resetparam()
{
   //  if(logger.islog())logger.file<<"cSearcher::resetparam()\n";
     param->iterdepth=0;
}

void cSearcher::updateiteration(const int score, const uint d)
{
     ASS(score>=-matescore&&score<=matescore);
   //  if(logger.islog())logger.file<<"cSearcher::updateiteration()\n";
     if(xb)
     {
       cout<<d;
       cout<<" "<<cpscore(score);
       cout<<"  "<<timer.time_elapsed()/10;
       cout<<" "<<data->nodes+data->qnodes;
       cout<<" ";
     }
     else//info depth 2 score cp 214 time 1242 nodes 2124 nps 34928 pv e2e4 e7e5 g1f3
     {
         cout<<"info depth "<<d;
         cout<<" score cp "<<cpscore(score);
         cout<<"  time "<<timer.time_elapsed()/1000;
         cout<<" nodes "<<data->nodes+data->qnodes;
         cout<<" pv ";
     }

     if(logger.islog()){logger.file<<"depth "<<d<<" score cp "<<cpscore(score);
                    logger.file<<"  time "<<timer.time_elapsed()/1000<<" nodes "<<data->nodes+data->qnodes;
                    logger.file<<" pv ";}

       printpv();
}

void cSearcher::printpv()
{
    uint movenum;
    uint length = data->pvlen[0];

    ASS(length<maxply);
    for(movenum = 0; movenum < length; ++movenum)
    {
           cout<<" "<<printmove(data->pv[0][movenum]);
           if(logger.islog()) logger.file<<" "<<printmove(data->pv[0][movenum]);
    }
    if(logger.islog()) logger.file<<"\n";
    cout<<endl;
}

void cSearcher::pvupdate(const uint move)
{
	uint i;
	uint ply = game.getply();

    for (i = ply + 1;  i < data->pvlen[ply+1]; i++)
        data->pv[ply][i] = data->pv[ply + 1][i];

    data->pv[ply][ply] = move;
    data->pvlen[ply] = data->pvlen[ply+1];

}


void cSearcher::loopcleanup(const int score)
{
     data->bestmove = data->pv[0][0];
     data->lastscore = score;
     if(data->pvlen[0]>1)//load of hash hits, no pv past move one
     {
      data->pondermove = data->pv[0][1];
     }
     else
     {
      data->pondermove = movefromhash(data->bestmove);
     }
     mlist.resetkillers();
}

uint cSearcher::movefromhash(uint makemefirst)
{
    uint hashmove = NULLMOVE;
    int beta = 0, hashscore = 0;//dummy
    bool nullperm;//dummy
    uint depth = 1;//100% certain of a hit...
    uint hashflag = tFlagNOTSET;

    makemove(game,mat,his,makemefirst);

    hashflag = ttable.probe_hashentry(hashscore, depth, hashmove, beta, nullperm, game.getkey(), game.getply());

    takemove(game,mat,his);

    return hashmove;
}

void cSearcher::compute()
{
    setmode(status->mode);
    if(logger.islog())
    {
        logger.file<<"cSearcher::compute()\n";
#ifdef DEBUG
        game.logboard();
#else
        logger.file<<fenfromboard(game, mat)<<endl;
#endif
        scorer.logeval(game,mat,ptab);
    }
    cout<<endl;

    if((status->mode & smPERFTSINGLE)!=0) perftsingle();
    else if((status->mode & smPERFTFILE)!=0) perftfile();
	else
	{
        timer.startsearchtimer(game.getside(), status->mode, param->ponderhit);
        resetdata();

	    iter_deep();

		ptab.says_stats();
		ttable.says_stats();
		mlist.says_stats();
		printstats();
	}
}

void cSearcher::setbestmove(const uint b)
{
	data->bestmove = b;
	if(logger.islog())logger.file<<"cSearcher::setbestmove() to "<<printmove(b)<<"\n";
}

bool cSearcher::checkmoveislegal(uint move)
{
    gen_all_moves(game, mat, mlist, NULLMOVE);
	uint *list = mlist.p2list(game.getply());
	bool found = false;// no. moves we have played
	for(uint i = 0; i < mlist.getcount(game.getply()); ++i)
	{
		if(list[i] == move) found=true;
	}

	if(!found) return false;

	if (makemove(game,mat,his,move))
	{
		 takemove(game,mat,his);
		 return false;
    }

    takemove(game,mat,his);

    return true;
}

void cSearcher::iter_deep()
{
    int alpha = -matescore;
    int beta = matescore;
    int score;
    uint bookmove = NULLMOVE;

    //if(logger.islog())logger.file<<"cSearcher::iter_deep()\n";

    if(book.usingbook() && (status->mode & (smPONDER|smINFINITE))==0)
    {
     book.bookmove(game.getkey(), bookmove);
     if(bookmove!=NULLMOVE)
     {
         if(checkmoveislegal(bookmove))
         {
          data->bestmove = bookmove;
          if(logger.islog())logger.file<<" book move "<<printmove(bookmove)<<endl;
          return;
         }
         else
         {
            if(logger.islog())logger.file<<" illegal book move "<<printmove(bookmove)<<endl;
         }
     }
    }

    for(uint i = 1; i <= param->iterdepth; ++i)
    {
       data->currentdepth = i;
       //score = alphabeta(alpha, beta, i, true, incheck(game,mat,game.getside()));
       score = presearch(i);
       if(i > 2 && status->stopped == STOPPED) return;
       loopcleanup(score);
       updateiteration(score,i);
    }

}

int cSearcher::presearch(const uint depth)
{
    ASS(depth<maxply);

    int score;
    int alpha = -matescore;
    int beta = matescore;

    if(opt->aspiration && depth > 2)//at least one score from the search to base the window on
    {
      alpha = cpscore(data->lastscore) - opt->aspwindow;
      beta = cpscore(data->lastscore) + opt->aspwindow;
#ifdef DEBUG
      if(logger.islog())
      {
          logger.file<<"window "<<opt->aspwindow<<" alpha "<<alpha;
          logger.file<<" beta "<<beta<<" lastscore "<<cpscore(data->lastscore)<<endl;
      }
      cout<<"\nwindow "<<opt->aspwindow<<" alpha "<<alpha;
      cout<<" beta "<<beta<<" lastscore "<<cpscore(data->lastscore)<<endl;
#endif
      score = alphabeta(alpha, beta, depth, true, incheck(game,mat,game.getside()));
      if(depth > 2 && status->stopped == STOPPED) return score;
      if(score <= alpha || score >= beta) //research
      {
#ifdef DEBUG
      if(logger.islog())
          logger.file<<"***********RESEARCH**********"<<endl;
      cout<<"**********RESEARCH*********"<<endl;
#endif
        alpha = -matescore;
        beta = matescore;
        score = alphabeta(alpha, beta, depth, true, incheck(game,mat,game.getside()));
      }
      return score;
    }
    else
    {
      alpha = -matescore;
      beta = matescore;
      score = alphabeta(alpha, beta, depth, true, incheck(game,mat,game.getside()));
      return score;
    }

    ASS(true==false); //can't get here
}



//check if we have a rep, fifty, or interruption
bool cSearcher::checkdraw()
{
    if(his.findrepetition(game.getkey()) && game.getply()) { return true;}
    if(game.getfifty()>100) {return true;}
    return false;
}


int  cSearcher::alphabeta(int alpha, int beta, int depth, bool nullperm, bool check)
{
    ASS(position_check(game,mat));
    if(checkdraw()) return 0;

    if(( (data->nodes + data->qnodes) & 2047) == 0)
    {
     if(data->currentdepth > 2)
     {
      if(timer.timeup() || checkinput())
      {
        status->stopped = STOPPED;
        if(logger.islog())logger.file<<"Search timeout\n";
        return 0;
      }
     }
    }

    if(game.getply()>=maxply) return scorer.eval(game,mat,ptab);

    data->pvlen[game.getply()] = game.getply();

    if(depth<=0)
    {
       // ASS(check==false);
        return quies(alpha,beta);
    }

    uint side = game.getside();

#ifdef DEBUG
    if(check==true) ASS(incheck(game,mat,side)==true);
    else ASS(incheck(game,mat,side)==false);
#endif

	data->nodes++;

	uint hashflag = tFlagNOTSET;
	uint hashmove = NULLMOVE;
	int hashscore = -matescore;

	if(game.getply() && opt->usehash)
    {
         hashflag = ttable.probe_hashentry(hashscore, depth, hashmove, beta, nullperm, game.getkey(), game.getply());
         if(hashflag!=tFlagNOTSET)
         {
           switch(hashflag)
           {
                   case tFlagEXACT:
                   stats->hashcuts++;
                   return hashscore;
                   break;
                   case tFlagUPPER:
                   if (hashscore <= alpha)
                   {stats->hashcuts++; return hashscore;}
                   break;
                   case tFlagLOWER:
                   if (hashscore >= beta)
                   {stats->hashcuts++; return hashscore;}
                   break;
                   default:
                   break;
           }
         }
    }

	if(opt->donull)
	{
	 if(scorer.lazyeval(game,mat) > beta && depth && nullperm && check == false && mat.getbigpieces(cW)+mat.getbigpieces(cB) > 0 && game.getply())
	 {
       int nscore;
       stats->nulltry++;
       makenullmove(game, mat, his);
       nscore = -alphabeta( -beta, -beta+1, depth-1-opt->nullredfact, false, false);
       takenullmove(game, his);
       ASS(position_check(game,mat));
       if(nscore>=beta) { stats->nullcuts++;return beta; }
	 }
	}

	int pvnode = ((beta-alpha)>1);

    gen_all_moves(game, mat, mlist, hashmove);
    uint *list = mlist.p2list(game.getply());
    int val = -matescore;
    uint played = 0;
    uint bestmove = NULLMOVE;
    uint ext;
    uint from;
    int old_alpha = alpha;
    bool foundpv = false;
    if(check && game.getply()==0) { stats->checkext++; depth++; }

    for(uint i = 0; i < mlist.getcount(game.getply()); ++i)
    {
        picknext(i,mlist);

     if (makemove(game,mat,his,list[i]))
     {
       takemove(game,mat,his);
       continue;
     }

     check = incheck(game,mat,game.getside());
     ext = 0;
     if(check) { stats->checkext++; ext = 1; }
     else extender(pvnode, ext, list[i]);

     if (foundpv && opt->pvs)
     {
        stats->pvssearch++;
        val = -alphabeta(-alpha-1, -alpha, depth-1+ext, true, check);
        if ((val > alpha) && (val < beta))
        {
            stats->pvsresearch++;
            val = -alphabeta( -beta, -alpha, depth-1+ext, true, check);
        }
     }
     else
     {
       val = -alphabeta( -beta, -alpha, depth-1+ext, true, check);
     }

     takemove(game,mat,his);
     if(status->stopped == STOPPED) { return 0;}

     played++;

     from = FROM(list[i]);

     if (val > alpha)
     {
         foundpv = true;
        bestmove = list[i];
        if (val >= beta)
        {
            if(played==1) stats->fhf++;
            else stats->fh++;

            ttable.store_hashentry(val, tFlagLOWER, bestmove, depth, game.getkey());
            mlist.score_killer(bestmove, val, game.getply());
            mlist.scoremove(list[i], depth, game.getpiece(from));
            return beta;
        }
            alpha = val;
            pvupdate(list[i]);
     }
   }

   if (played == 0)
	{
		if (check)
		{
		    return -matescore + game.getply();
		}
		else
		{
			return 0;
		}
	}

	if(alpha>old_alpha)
	ttable.store_hashentry(alpha, tFlagEXACT, bestmove, depth, game.getkey());
    else
    ttable.store_hashentry(old_alpha, tFlagUPPER, NULLMOVE, depth, game.getkey());

    return alpha;
}


int  cSearcher::quies(int alpha, int beta)
{

    if(game.getply()>=maxply) return scorer.eval(game,mat,ptab);;
    if(checkdraw()) return 0;

    int score = scorer.eval(game,mat,ptab);
    data->qnodes++;
    if(score>=beta) return beta;
    if(score > alpha) alpha = score;

    gen_all_captures(game, mat, mlist);
    uint *list = mlist.p2list(game.getply());

    int val = -matescore;

    for(uint i = 0; i < mlist.getcount(game.getply()); ++i)
    {
      picknext(i,mlist);
     if (makemove(game,mat,his,list[i]))
     {
       takemove(game,mat,his);
       continue;
     }

     val = -quies( -beta, -alpha);
     takemove(game,mat,his);


     if (val >= beta)
            return beta;
     if (val > alpha)
     {
            alpha = val;
      }
   }

    return alpha;
}


void cSearcher::picknext(const int from, cMovelist &mlist)
{
    uint i;
    int bs;
    int bi;
    uint g;

    bs = -matescore;
    bi = from;
    int s;
    uint *list = mlist.p2list(game.getply());
    int *sc = mlist.p2scores(game.getply());

    for (i = from; i < mlist.getcount(game.getply()); ++i)
    {
        s=sc[i];
        if ( s > bs)
        {
            bs =  sc[i];
            bi = i;
        }
    }

    g =  list[from];
    list[from] =  list[bi];
    list[bi] = g;

    g =  sc[from];
    sc[from] =  sc[bi];
    sc[bi] = g;
}

void cSearcher::extender(int pvnode, uint &ext, uint move)
{
    uint from = FROM(move);
    uint to = TO(move);
    uint cap = CAP(move);
    uint lastside;
    uint pce;
    ASS(ext==0);
    ASS(onbrd(from));
    ASS(onbrd(to));

    lastside = game.getside()^1;
    pce = game.getpiece(to);
    ASS(piecegood(pce));
    ASS(lastside==cW || lastside==cB);
    ASS(pcecolour(pce)==lastside);

    if(pvnode)
    {
        if(pce==pwP && ranks[to]==RANK7)
        {
            ext=1;
            stats->pawnseventh++;
        }
        else if(pce==pbP && ranks[to]==RANK2)
        {
            ext=1;
            stats->pawnseventh++;
        }
    }

    if( (mat.getpcenum(pwP)+mat.getpcenum(pbP) == 0) && cap > pbP)
    {
        ASS(cap<pwK);
        ext=1;
        stats->intopawnend++;
    }
    ASS(ext==0||ext==1);
}
